#ifndef _PLAYER_H
#define _PLAYER_H

#define SHOT_NORMAL 0
#define SHOT_DOUBLE 1
#define SHOT_SPREAD 2

#define SHOT_PLUS  0
#define SHOT_MINUS 1

typedef struct _powerup
{
	float x, y, yv;
	short type;
} _powerup;

typedef struct _shot
{
	const static int w = 5;
	const static int h = 5;
	
	float x, y, xv, yv;
	
	void move();
	void draw();
	bool offscreen();
} _shot;

typedef struct _player
{
	const static int w = 25;
	const static int h = 25;
	
	bool insane;
	bool twoplayer;
	short shotmode, shotdelay, shotdelay2;
	short craziness;  // 0-100
	short health;  //0-100
	short timesinsane;
	float x, y, xv, yv;
	list<_shot> pshot;
	
	void init(bool _twoplayer);
	void newlife();
	void do_stuff();
	void move();
	void take_damage(int damage);
	void draw();
	void fire();
	void p2_fire();
} _player;

extern _player player;
extern list<_powerup> powerups;

#endif
